////////////////////////////////////////////////////////////////////////////////
// CONFIDENTIAL and PROPRIETARY software of Magewell Electronics Co., Ltd.
// Copyright (c) 2011-2014 Magewell Electronics Co., Ltd. (Nanjing)
// All rights reserved.
// This copyright notice MUST be reproduced on all authorized copies.
////////////////////////////////////////////////////////////////////////////////
#ifndef __MW_LINUX__
#define __MW_LINUX__

#define MW_MAX_PROCESS_NAME_LEN (64)

#include <sys/types.h>
#include "MWCaptureExtension.h"

#define MW_MAC_IOC(x)           (x)
#define MW_MAC_IOCR(x)          (0x01000000 | (x))
#define MW_MAC_IOCW(x)          (0x02000000 | (x))
#define MW_MAC_IOCRW(x)         (0x03000000 | (x))

#define MW_MAC_IOC_DIR(x)       (((x) >> 24) & 0x3)
#define MW_MAC_IOC_READ         (0x1)
#define MW_MAC_IOC_WRITE        (0x2)


enum ProCaptureDriverIoctl{
    MWCAP_IOCTL_GET_STREAMS_COUNT,
    MWCAP_IOCTL_GET_STREAMS_INFO,
    MWCAP_IOCTL_GET_CTRL_STREAM_ID,
    MWCAP_IOCTL_SET_CTRL_STREAM_ID,
    MWCAP_IOCTL_GET_SELF_STREAM_ID,

    MWCAP_IOCTL_GET_CHANNEL_INFO        = MW_MAC_IOCR(0x10),
    MWCAP_IOCTL_GET_FAMILY_INFO         = MW_MAC_IOCR(0x11),
    MWCAP_IOCTL_GET_VIDEO_CAPS          = MW_MAC_IOCR(0x12),
    MWCAP_IOCTL_GET_AUDIO_CAPS          = MW_MAC_IOCR(0x13),

    // Firmware upgrade
    MWCAP_IOCTL_GET_FIRMWARE_STORAGE,
    MWCAP_IOCTL_SET_FIRMWARE_ERASE,
    MWCAP_IOCTL_SET_FIRMWARE_DATA,
    MWCAP_IOCTL_GET_FIRMWARE_DATA,

    // Device misc controls
    MWCAP_IOCTL_SET_LED_MODE            = MW_MAC_IOCW(0x20),
    MWCAP_IOCTL_SET_POST_RECONFIG       = MW_MAC_IOCW(0x21),
    MWCAP_IOCTL_GET_CORE_TEMPERATURE    = MW_MAC_IOCR(0x22),

    // Hardware timer
    MWCAP_IOCTL_GET_TIME                = MW_MAC_IOCR(0x23),
    MWCAP_IOCTL_SET_TIME                = MW_MAC_IOCW(0x24),
    MWCAP_IOCTL_TIME_REGULATION         = MW_MAC_IOCW(0x25),

    MWCAP_IOCTL_TIMER_REGISTRATION      = MW_MAC_IOCRW(0x26),
    MWCAP_IOCTL_TIMER_DEREGISTRATION    = MW_MAC_IOCW(0x27),
    MWCAP_IOCTL_TIMER_EXPIRE_TIME       = MW_MAC_IOCW(0x28),

    // Notifications
    MWCAP_IOCTL_NOTIFY_REGISTRATION     = MW_MAC_IOCRW(0x29),
    MWCAP_IOCTL_NOTIFY_DEREGISTRATION   = MW_MAC_IOCW(0x2A),
    MWCAP_IOCTL_NOTIFY_STATUS           = MW_MAC_IOCRW(0x2B),
    MWCAP_IOCTL_NOTIFY_ENABLE           = MW_MAC_IOCW(0x2C),

    // Video frame information
    MWCAP_IOCTL_GET_VIDEO_BUFFER_INFO   = MW_MAC_IOCR(0x2E),
    MWCAP_IOCTL_GET_VIDEO_FRAME_INFO    = MW_MAC_IOCRW(0x2F),

    // Video capture
    MWCAP_IOCTL_VIDEO_CAPTURE_OPEN      = MW_MAC_IOC(0x30),
    MWCAP_IOCTL_VIDEO_CAPTURE_FRAME     = MW_MAC_IOCW(0x31),
    MWCAP_IOCTL_VIDEO_CAPTURE_CLOSE     = MW_MAC_IOC(0x32),
    MWCAP_IOCTL_VIDEO_CAPTURE_STATUS    = MW_MAC_IOCR(0x36),

    // Audio capture
    MWCAP_IOCTL_AUDIO_CAPTURE_OPEN      = MW_MAC_IOC(0x33),
    MWCAP_IOCTL_AUDIO_CAPTURE_FRAME     = MW_MAC_IOCR(0x34),
    MWCAP_IOCTL_AUDIO_CAPTURE_CLOSE     = MW_MAC_IOC(0x35),

    // Input source
    MWCAP_IOCTL_VIDEO_INPUT_SOURCE_COUNT    = MW_MAC_IOCR(0x40),
    MWCAP_IOCTL_VIDEO_INPUT_SOURCE_ARRAY    = MW_MAC_IOCRW(0x41),

    MWCAP_IOCTL_AUDIO_INPUT_SOURCE_COUNT    = MW_MAC_IOCR(0x42),
    MWCAP_IOCTL_AUDIO_INPUT_SOURCE_ARRAY    = MW_MAC_IOCRW(0x43),

    MWCAP_IOCTL_SET_INPUT_SOURCE_SCAN       = MW_MAC_IOCW(0x44),
    MWCAP_IOCTL_GET_INPUT_SOURCE_SCAN       = MW_MAC_IOCR(0x45),
    MWCAP_IOCTL_GET_INPUT_SOURCE_SCAN_STATE = MW_MAC_IOCR(0x46),
    MWCAP_IOCTL_SET_AV_INPUT_SOURCE_LINK    = MW_MAC_IOCW(0x47),
    MWCAP_IOCTL_GET_AV_INPUT_SOURCE_LINK    = MW_MAC_IOCR(0x48),
    MWCAP_IOCTL_SET_VIDEO_INPUT_SOURCE      = MW_MAC_IOCW(0x49),
    MWCAP_IOCTL_GET_VIDEO_INPUT_SOURCE      = MW_MAC_IOCR(0x4A),
    MWCAP_IOCTL_SET_AUDIO_INPUT_SOURCE      = MW_MAC_IOCW(0x4B),
    MWCAP_IOCTL_GET_AUDIO_INPUT_SOURCE      = MW_MAC_IOCR(0x4C),

    // EDID
    MWCAP_IOCTL_GET_EDID_DATA               = MW_MAC_IOCRW(0x50),
    MWCAP_IOCTL_SET_EDID_DATA               = MW_MAC_IOCW(0x51),

    // Signal status
    MWCAP_IOCTL_GET_INPUT_SPECIFIC_STATUS   = MW_MAC_IOCR(0x52),
    MWCAP_IOCTL_GET_VIDEO_SIGNAL_STATUS     = MW_MAC_IOCR(0x53),
    MWCAP_IOCTL_GET_AUDIO_SIGNAL_STATUS     = MW_MAC_IOCR(0x54),

    // HDMI status
    MWCAP_IOCTL_GET_HDMI_INFOFRAME_VALID    = MW_MAC_IOCR(0x55),
    MWCAP_IOCTL_GET_HDMI_INFOFRAME_PACKET   = MW_MAC_IOCR(0x56),

    // Video processing
    MWCAP_IOCTL_GET_VIDEO_INPUT_ASPECT_RATIO    = MW_MAC_IOCR(0x57),
    MWCAP_IOCTL_SET_VIDEO_INPUT_ASPECT_RATIO    = MW_MAC_IOCW(0x58),
    MWCAP_IOCTL_GET_VIDEO_INPUT_COLOR_FORMAT    = MW_MAC_IOCR(0x59),
    MWCAP_IOCTL_SET_VIDEO_INPUT_COLOR_FORMAT    = MW_MAC_IOCW(0x5A),
    MWCAP_IOCTL_GET_VIDEO_INPUT_QUANTIZATION_RANGE  = MW_MAC_IOCR(0x5B),
    MWCAP_IOCTL_SET_VIDEO_INPUT_QUANTIZATION_RANGE  = MW_MAC_IOCW(0x5C),

    // Image upload, can be use as source image or OSD image
    MWCAP_IOCTL_VIDEO_CREATE_IMAGE,
    MWCAP_IOCTL_VIDEO_OPEN_IMAGE,
    MWCAP_IOCTL_VIDEO_CLOSE_IMAGE,
    MWCAP_IOCTL_VIDEO_UPLOAD_IMAGE,

    // VGA/Component timings
    MWCAP_IOCTL_GET_VIDEO_AUTO_H_ALIGN = MW_MAC_IOCR(0x70),
    MWCAP_IOCTL_SET_VIDEO_AUTO_H_ALIGN = MW_MAC_IOCW(0x71),
    /* (0-31, 255 triger auto adjust once) */
    MWCAP_IOCTL_GET_VIDEO_SAMPLING_PHASE = MW_MAC_IOCR(0x72),
    MWCAP_IOCTL_SET_VIDEO_SAMPLING_PHASE = MW_MAC_IOCW(0x73),
    MWCAP_IOCTL_GET_VIDEO_SAMPLING_PHASE_AUTO = MW_MAC_IOCR(0x74),
    MWCAP_IOCTL_SET_VIDEO_SAMPLING_PHASE_AUTO = MW_MAC_IOCW(0x75),
    MWCAP_IOCTL_SET_VIDEO_TIMING = MW_MAC_IOCW(0x76),
    MWCAP_IOCTL_GET_VIDEO_PREFERRED_TIMING_ARRAY = MW_MAC_IOCRW(0x77),
    MWCAP_IOCTL_SET_VIDEO_CUSTOM_TIMING = MW_MAC_IOCW(0x78),
    MWCAP_IOCTL_GET_VIDEO_CUSTOM_TIMING_COUNT = MW_MAC_IOCR(0x79),
    MWCAP_IOCTL_GET_VIDEO_CUSTOM_TIMING_ARRAY = MW_MAC_IOCRW(0x7A),
    MWCAP_IOCTL_SET_VIDEO_CUSTOM_TIMING_ARRAY = MW_MAC_IOCW(0x7B),
    MWCAP_IOCTL_GET_VIDEO_CUSTOM_RESOLUTION_COUNT = MW_MAC_IOCR(0x7C),
    MWCAP_IOCTL_GET_VIDEO_CUSTOM_RESOLUTION_ARRAY = MW_MAC_IOCRW(0x7D),
    MWCAP_IOCTL_SET_VIDEO_CUSTOM_RESOLUTION_ARRAY = MW_MAC_IOCW(0x7E),


    /* Video capture enhancement */
    MWCAP_IOCTL_VIDEO_PIN_BUFFER = MW_MAC_IOCW(0x80),
    MWCAP_IOCTL_VIDEO_UNPIN_BUFFER = MW_MAC_IOCW(0x81),


    /* save current process settings and osd settings as default for this device */
    MWCAP_IOCTL_SETTINGS_SAVE_AS_PRESET,
    /* reload default settings to overwrite current process settings and osd settings */
    MWCAP_IOCTL_SETTINGS_RELOAD_PRESET,

    // Video processing (NOT functional for mwcap stream)
    MWCAP_IOCTL_GET_VIDEO_CONNECTION_FORMAT,
    MWCAP_IOCTL_GET_VIDEO_PROCESS_SETTINGS,
    MWCAP_IOCTL_SET_VIDEO_PROCESS_SETTINGS,
    MWCAP_IOCTL_GET_VIDEO_OSD_SETTINGS,
    MWCAP_IOCTL_SET_VIDEO_OSD_SETTINGS,
    MWCAP_IOCTL_GET_VIDEO_OSD_IMAGE,
    MWCAP_IOCTL_SET_VIDEO_OSD_IMAGE,

    // Video AMP
    MWCAP_IOCTL_GET_BRIGHTNESS,
    MWCAP_IOCTL_SET_BRIGHTNESS,
    MWCAP_IOCTL_GET_CONTRAST,
    MWCAP_IOCTL_SET_CONTRAST,
    MWCAP_IOCTL_GET_HUE,
    MWCAP_IOCTL_SET_HUE,
    MWCAP_IOCTL_GET_SATURATION,
    MWCAP_IOCTL_SET_SATURATION,

    // SDI ANC Packet
    MWCAP_IOCTL_SET_SDI_ANC_TYPE = MW_MAC_IOCW(0x82),
    MWCAP_IOCTL_GET_SDI_ANC_PACKET = MW_MAC_IOCR(0x83),


    /* Get SDI ANC Packats binding to currently dequeued frame via V4L2.
     * This is conflicting with MWCAP_IOCTL_GET_SDI_ANC_PACKET. You can
     * use only one of them at the same time.,
     */
    MWCAP_IOCTL_GET_V4L2_FRAME_SDI_ANC_PACKETS,
    MWCAP_IOCTL_GET_ENABLE_V4L2_FRAME_SDI_ANC,
    MWCAP_IOCTL_SET_ENABLE_V4L2_FRAME_SDI_ANC,

    MWCAP_IOCTL_VIDEO_ECO_CAPTURE_OPEN,
    MWCAP_IOCTL_VIDEO_ECO_CAPTURE_GET_SETTINGS,
    MWCAP_IOCTL_VIDEO_ECO_CAPTURE_SET_SETTINGS,
    MWCAP_IOCTL_VIDEO_ECO_CAPTURE_FRAME,
    MWCAP_IOCTL_VIDEO_ECO_CAPTURE_STATUS,
    MWCAP_IOCTL_VIDEO_ECO_CAPTURE_CLOSE,

    MWCAP_IOCTL_VIDEO_UPLOAD_STATUS_IMAGE  = MW_MAC_IOCW(0x8F),

};

#pragma pack(push)
#pragma pack(1)

typedef struct _MWCAP_IOCTL_VIDEO_UPLOAD_STATUS_IMAGE {
    uint8_t type;   // 0: Nosignal, 1: Locking, 2: Unsupported
    uint16_t width;
    uint16_t height;
    uint64_t buf_addr;
    uint32_t buf_size;
} MWCAP_VIDEO_UPLOAD_STATUS_IMAGE;

typedef struct _MWCAP_STREAM_INFO {
    int                 stream_id; /* >1 */
//    pid_t               pid;    /* proc id */
    char                comm[MW_MAX_PROCESS_NAME_LEN]; /* executable name excluding path */
    bool                streaming; /* ONLY for os local function, not mwcap */
} MWCAP_STREAM_INFO;

typedef struct _MWCAP_STREAMS_INFO {
    int                     count;
    MWCAP_PTR               infos; /* (MWCAP_STREAM_INFO, infos) */
} MWCAP_STREAMS_INFO;

typedef struct _MWCAP_FIRMWARE_DATA {
    unsigned int        offset;
    unsigned int        size; /* data size */
    MWCAP_PTR           data; /* (unsigned char * data) */
} MWCAP_FIRMWARE_DATA;

typedef struct _MWCAP_INPUT_SOURCE_ARRAY {
    unsigned int        count; /* count of element, user set */
    MWCAP_PTR           data; /* (unsigned int * data) */
} MWCAP_INPUT_SOURCE_ARRAY;

typedef struct _MWCAP_EDID_DATA {
    int                 size;
    MWCAP_PTR           data; /* (unsigned char * data) */
} MWCAP_EDID_DATA;

typedef struct _MWCAP_HDMI_INFOFRAME_PACKET {
    unsigned int                id;
    HDMI_INFOFRAME_PACKET       pkt;
} MWCAP_HDMI_INFOFRAME_PACKET;

typedef struct _MWCAP_VIDEO_TIMING_PAR {
    int                                 count; // max: MWCAP_VIDEO_MAX_NUM_PREFERRED_TIMINGS
    MWCAP_PTR                           timings; /* (MWCAP_VIDEO_TIMING * timings) */
} MWCAP_VIDEO_TIMING_PAR;

typedef struct _MWCAP_VIDEO_CUSTOM_TIMING_PAR {
    int                                 count;
    MWCAP_PTR                           timings; /* (MWCAP_VIDEO_CUSTOM_TIMING * timings) */
} MWCAP_VIDEO_CUSTOM_TIMING_PAR;

typedef struct _MWCAP_VIDEO_CUSTOM_RESOLUTION_PAR {
    int                                 count;
    MWCAP_PTR                           resolutions; /* (MWCAP_SIZE * resolutions) */
} MWCAP_VIDEO_CUSTOM_RESOLUTION_PAR;

typedef struct _MWCAP_VIDEO_FRAME_INFO_PAR {
    int                                 iframe; // set
    MWCAP_VIDEO_FRAME_INFO              info;   // get
} MWCAP_VIDEO_FRAME_INFO_PAR;

#pragma pack(pop)

#endif /* __MW_LINUX__ */
