////////////////////////////////////////////////////////////////////////////////
// CONFIDENTIAL and PROPRIETARY software of Magewell Electronics Co., Ltd.
// Copyright (c) 2011-2019 Magewell Electronics Co., Ltd. (Nanjing)
// All rights reserved.
// This copyright notice MUST be reproduced on all authorized copies.
////////////////////////////////////////////////////////////////////////////////

#import "ViewController.h"

#import "CaptureView.h"
#import "CaptureUtil.h"


@interface ViewController ()<CaptureViewDelegate>
{

}
@property(nonatomic,strong)CaptureView   *captureView1;
@property(nonatomic,strong)CaptureView   *captureView2;
@property(nonatomic,strong)NSMutableArray<NSLayoutConstraint *> *constraintList;

@end

@implementation ViewController
- (void)viewDidLoad {
    [self.view setWantsLayer:YES];
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.constraintList = [[NSMutableArray alloc] init];
        
    NSMenu *mainMenu = [NSApp mainMenu];
    
    NSMenuItem *lineControlItem = [[NSMenuItem alloc] init];
    [mainMenu addItem:lineControlItem];
    self.lineMenu = [[NSMenu alloc] initWithTitle:@"Line"];
    [lineControlItem setSubmenu:self.lineMenu];
    
    NSMenuItem *signalItem = [self.lineMenu addItemWithTitle:@"Signal" action:@selector(singleCapture:) keyEquivalent:@""];
    [signalItem setTag:0];
    
    NSMenuItem *multiItem = [self.lineMenu addItemWithTitle:@"Multi" action:@selector(multiCapture:) keyEquivalent:@""];
    [multiItem setTag:1];
    
    [self singleCapture:signalItem];
    
    NSString *a;
    int b = a.length;
    bool c = [a isEqualToString:@""];
    NSRange range = [a rangeOfString:@""];
    NSLog(@"");
    
    
//    [self parseArgs];
    
}

- (BOOL)windowShouldClose:(NSWindow *)sender {
    
    [self stopLine2];
    [self stopLine1];
    
    return YES;
}

- (void)viewDidDisappear {
    [self stopLine2];
    [self stopLine1];
}

- (void)setRepresentedObject:(id)representedObject {
    [super setRepresentedObject:representedObject];

    // Update the view, if already loaded.
}

- (void)multiCapture:(NSMenuItem *)item
{
    NSMenuItem * selectedItem;
    if (self.lineMenu.selectedItems.count > 0) {
        if (@available(macOS 14.0, *)) {
            selectedItem = self.lineMenu.selectedItems.firstObject;
        } else {
            // Fallback on earlier versions
        }
    }
    if (selectedItem == item) {
        return;
    }
    if (selectedItem) {
        [selectedItem setState:NSControlStateValueOff];
        [item setState:NSControlStateValueOn];
        //启动第二路采集
        [self startLine2];
    }
}

- (void)singleCapture:(NSMenuItem *)item
{
    NSMenuItem * selectedItem;
    if (self.lineMenu.selectedItems.count > 0) {
        if (@available(macOS 14.0, *)) {
            selectedItem = self.lineMenu.selectedItems.firstObject;
        } else {
            // Fallback on earlier versions
        }
    }
    if (selectedItem == item) {
        return;
    }
    if (selectedItem) {
        [selectedItem setState:NSControlStateValueOff];
        [item setState:NSControlStateValueOn];
        //停止第二路采集
        [self stopLine2];
    } else {
        [item setState:NSControlStateValueOn];
        //启动第一路采集
        [self startLine1];
    }
}

- (void)startLine1
{
    self.captureView1 = [[CaptureView alloc] initWithFrame:self.view.frame lineNumber:1];
    [self.view addSubview:self.captureView1];
    self.captureView1.autoresizingMask = NSViewWidthSizable | NSViewHeightSizable;
    self.captureView1.layer.backgroundColor = [NSColor redColor].CGColor;
    self.captureView1.translatesAutoresizingMaskIntoConstraints = NO;
    self.captureView1.delegate = self;
    
    [self.view removeConstraints:self.constraintList];
    [self.constraintList removeAllObjects];
    
    NSLayoutConstraint *constraintWidth = [NSLayoutConstraint constraintWithItem:self.captureView1 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeWidth multiplier:1 constant:0];
    [self.view addConstraint:constraintWidth];
    [self.constraintList addObject:constraintWidth];
    
    NSLayoutConstraint *constraintHeight = [NSLayoutConstraint constraintWithItem:self.captureView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeHeight multiplier:1 constant:0];
    [self.view addConstraint:constraintHeight];
    [self.constraintList addObject:constraintHeight];
}

- (void)stopLine1
{
    if (self.captureView1) {
        [self.captureView1 destory];
        [self.captureView1 removeFromSuperview];
        self.captureView1 = nil;
    }
}

- (void)startLine2
{
    if (self.captureView1) {
        self.captureView1.frame = CGRectMake(0, 0, self.view.frame.size.width/2.0, self.view.frame.size.height);
    }
    
    self.captureView2 = [[CaptureView alloc] initWithFrame:CGRectMake(self.view.frame.size.width/2.0, 0, self.view.frame.size.width/2.0, self.view.frame.size.height) lineNumber:2];
    [self.view addSubview:self.captureView2];
    self.captureView2.layer.backgroundColor = [NSColor yellowColor].CGColor;
    self.captureView2.translatesAutoresizingMaskIntoConstraints = NO;
    self.captureView2.delegate = self;
    
    [self.view removeConstraints:self.constraintList];
    [self.constraintList removeAllObjects];
    
    // 假设self.view是父视图，view1和view2是子视图
    NSLayoutConstraint *constraintWidth = [NSLayoutConstraint constraintWithItem:self.captureView1 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeWidth multiplier:0.5 constant:0];
    [self.view addConstraint:constraintWidth];
    [self.constraintList addObject:constraintWidth];
    
    NSLayoutConstraint *constraintHeight = [NSLayoutConstraint constraintWithItem:self.captureView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeHeight multiplier:1 constant:0];
    [self.view addConstraint:constraintHeight];
    [self.constraintList addObject:constraintHeight];

     
    NSLayoutConstraint *constraintRight = [NSLayoutConstraint constraintWithItem:self.captureView2 attribute:NSLayoutAttributeLeading relatedBy:NSLayoutRelationEqual toItem:self.captureView1 attribute:NSLayoutAttributeTrailing multiplier:1 constant:0];
    [self.view addConstraint:constraintRight];
    [self.constraintList addObject:constraintRight];

    NSLayoutConstraint *constraintWidth2 = [NSLayoutConstraint constraintWithItem:self.captureView2 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeWidth multiplier:0.5 constant:0];
    [self.view addConstraint:constraintWidth2];
    [self.constraintList addObject:constraintWidth2];
    
    NSLayoutConstraint *constraintHeight2 = [NSLayoutConstraint constraintWithItem:self.captureView2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeHeight multiplier:1 constant:0];
    [self.view addConstraint:constraintHeight2];
    [self.constraintList addObject:constraintHeight2];
}

- (void)stopLine2
{
    NSMenu *mainMenu = [NSApp mainMenu];
    int count = (int)mainMenu.itemArray.count;
    if (count > 5) {
        [mainMenu removeItemAtIndex:count-1];
        [mainMenu removeItemAtIndex:count-2];
        [mainMenu removeItemAtIndex:count-3];
        [mainMenu removeItemAtIndex:count-4];
        [mainMenu removeItemAtIndex:count-5];
    }
    
    if (self.captureView2) {
        [self.captureView2 destory];
        [self.captureView2 removeFromSuperview];
        self.captureView2 = nil;
    }
    if (self.captureView1) {
        self.captureView1.frame = self.view.frame;
//        self.captureView1.autoresizingMask = NSViewWidthSizable | NSViewHeightSizable;
    }
    
    [self.view removeConstraints:self.constraintList];
    [self.constraintList removeAllObjects];
    
    NSLayoutConstraint *constraintWidth = [NSLayoutConstraint constraintWithItem:self.captureView1 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeWidth multiplier:1 constant:0];
    [self.view addConstraint:constraintWidth];
    [self.constraintList addObject:constraintWidth];
    
    NSLayoutConstraint *constraintHeight = [NSLayoutConstraint constraintWithItem:self.captureView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeHeight multiplier:1 constant:0];
    [self.view addConstraint:constraintHeight];
    [self.constraintList addObject:constraintHeight];
}

#pragma mark - CaptureViewDelegate
- (BOOL)isDeviceInUse:(NSString*)devicePath
{
    if (self.captureView1 && [devicePath isEqualToString:self.captureView1.inUseDevicePath]) {
        return YES;
    }
    if (self.captureView2 && [devicePath isEqualToString:self.captureView2.inUseDevicePath]) {
        return YES;
    }
    return NO;
}

@end
