//
//  CaptureView.h
//  AVCapture2
//
//  Created by magewell on 2025/8/20.
//  Copyright © 2025 magewell. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AVFoundation/AVSampleBufferDisplayLayer.h>

#include "MWFOURCC.h"
#include "LibMWCapture/MWCapture.h"
#include "MWAudioRender.h"

NS_ASSUME_NONNULL_BEGIN

@protocol CaptureViewDelegate  <NSObject>
@optional
- (BOOL)isDeviceInUse:(NSString*)devicePath;
@end

@interface CaptureView : NSView

@property (nonatomic, assign) id<CaptureViewDelegate> delegate;

//video params
@property (nonatomic, assign) uint32_t width;
@property (nonatomic, assign) uint32_t height;
@property (nonatomic, assign) uint32_t frameDuration;
@property (nonatomic, assign) uint32_t fourcc;

//audio params
@property (nonatomic, assign) uint32_t samplerate;
@property (nonatomic, assign) uint32_t audioChannels;
@property (nonatomic, assign) uint32_t bitsPerSample;

//av capture
@property (nonatomic, assign) void  *audioRender;
@property (nonatomic, assign) HANDLE audioCapture;
@property (nonatomic, assign) HANDLE videoCapture;

- (void)onVideoCaptureFrame:(BYTE *)pBuffer bufferLen:(long)bufferLen stride:(long) stride;
- (void)onAudioCaptureFrame:(BYTE *)pbFrame cbFrame:(int)cbFrame u64TimeStamp:(uint64_t)u64TimeStamp;

//statistics
@property (atomic, assign) float captureFps;
@property (nonatomic, assign) uint64_t lastTimestamp;
@property (nonatomic, assign) uint32_t videoFrameCount;

@property (nonatomic, assign) uint64_t previousPts;
@property (nonatomic, assign) uint64_t delayVideoFrameCount;
@property (nonatomic, assign) uint64_t dropVideoFrameCount;

//UI
@property (nonatomic, assign) int32_t viewEnable;
@property (nonatomic, strong) AVSampleBufferDisplayLayer *videoLayer;
@property (nonatomic, assign) OSType pixelFormat;
@property (nonatomic, strong) NSMenu *deviceMenu;
@property (nonatomic, strong) NSMenuItem *selectedDeviceItem;
@property (nonatomic, strong) NSMenu *audioMenu;
@property (nonatomic, strong) NSMenuItem *selectedAudioItem;
@property (nonatomic, strong) NSMenu *resolutionsMenu;
@property (nonatomic, strong) NSMenuItem *selectedResolutionItem;
@property (nonatomic, strong) NSMenu *fpsMenu;
@property (nonatomic, strong) NSMenuItem *selectedFpsItem;
@property (nonatomic, strong) NSMenu *fourccMenu;
@property (nonatomic, strong) NSMenuItem *selectedFourccItem;
@property (nonatomic, strong) NSTimer *statusTimer;
@property (nonatomic, strong) NSTextField *statusLabel;
@property (nonatomic, strong) NSMutableArray *suportCaptureFormatList;
@property (nonatomic, assign) int lineNumber;
@property (nonatomic, assign) BOOL continuousAutoSwitch;
@property (nonatomic, assign) int currentCaptrueFormatIndex;
@property (nonatomic, strong) NSTimer *timer;
@property (nonatomic, strong) NSString *inUseDevicePath;


- (id)initWithFrame:(NSRect)frameRect lineNumber:(int)lineNumber;
- (void)destory;
@end

NS_ASSUME_NONNULL_END
