//
//  CaptureView.h
//  AudioCapture
//
//  Created by magewell on 2025/9/25.
//  Copyright © 2025 magewell. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AVFoundation/AVSampleBufferDisplayLayer.h>

#include "MWFOURCC.h"
#include "LibMWCapture/MWCapture.h"
#include "MWAudioRender.h"
#include "LibMWVenc/mw_venc.h"
#include "MWAudioEncode.h"
#include "LibMWMp4/mw_mp4.h"

NS_ASSUME_NONNULL_BEGIN

@protocol MWCaptureViewDelegate  <NSObject>
@optional
- (BOOL)isDeviceInUse:(NSString*)devicePath;
@end

@interface MWCaptureView : NSView
{
    
}
@property (nonatomic, assign) id<MWCaptureViewDelegate> delegate;

//capture
@property (nonatomic, assign) uint32_t width;
@property (nonatomic, assign) uint32_t height;
@property (nonatomic, assign) uint32_t frameDuration;
@property (nonatomic, assign) uint32_t fourcc;
@property (nonatomic, assign) OSType pixelFormat;

@property (nonatomic, assign) uint32_t samplerate;
@property (nonatomic, assign) uint32_t audioChannels;
@property (nonatomic, assign) uint32_t bitsPerSample;

@property (nonatomic, assign) void  *audioRender;

@property (nonatomic, assign) HCHANNEL hChannel;
@property (nonatomic, assign) void *capturePixelFrameQueue;
@property (nonatomic, retain) NSLock *capturePixelFrameLock;
@property (nonatomic, assign) bool running;
@property (nonatomic, assign) pthread_t videoCaptureThreadId;
@property (nonatomic, assign) pthread_t audioCaptureThreadId;

@property (atomic, assign) float captureFps;
@property (nonatomic, assign) uint64_t lastTimestamp;
@property (nonatomic, assign) uint32_t videoFrameCount;
@property (nonatomic, assign) MWCAP_PTR videoCaptureEvent;
@property (nonatomic, assign) MWCAP_PTR audioCaptureEvent;

@property (nonatomic, assign) uint64_t previousPts;
@property (nonatomic, assign) uint64_t delayVideoFrameCount;
@property (nonatomic, assign) uint64_t dropVideoFrameCount;


//video encode
@property (nonatomic, assign) uint32 bitRate;
@property (nonatomic, assign) bool h265Enable;
@property (nonatomic, assign) mw_venc_handle_t vtEnc;
@property (nonatomic, retain) NSLock *vtEncLock;
@property (nonatomic, assign) void *encPixelFrameQueue;
@property (nonatomic, assign) bool encoding;
@property (nonatomic, assign) pthread_t videoEncodeThreadId;

@property (atomic, assign) float encodeFps;
@property (nonatomic, assign) uint64_t lastEncodeTimestamp;
@property (nonatomic, assign) uint32_t encodeFrameCount;

//audio encode
@property (nonatomic, assign) FAACEncoder *aacEnc;
@property (nonatomic, retain) NSLock *aacEncLock;

//mp4 recode
@property (nonatomic, assign) mw_mp4_handle_t mp4Record;
@property (nonatomic, assign) bool gotVideoTrack;
@property (nonatomic, assign) bool gotAudioTrack;
@property (nonatomic, assign) uint8_t *videoBufferFrame;
@property (nonatomic, assign) size_t videoBufferFrameSize;
@property (nonatomic, assign) uint64_t startRecordTime;

//UI
@property (nonatomic, assign) int32_t viewEnable;
@property (nonatomic, retain) AVSampleBufferDisplayLayer *videoLayer;
@property (nonatomic, retain) NSMenu *deviceMenu;
@property (nonatomic, retain) NSMenuItem *selectedDeviceItem;
@property (nonatomic, retain) NSMenuItem *startRecordItem;
@property (nonatomic, retain) NSMenuItem *stopRecordItem;
@property (nonatomic, retain) NSTimer *statusTimer;
@property (nonatomic, retain) NSTextField *statusLabel;
@property (nonatomic, strong) NSMenu *resolutionsMenu;
@property (nonatomic, strong) NSMenuItem *selectedResolutionItem;
@property (nonatomic, strong) NSMenu *fpsMenu;
@property (nonatomic, strong) NSMenuItem *selectedFpsItem;
@property (nonatomic, strong) NSMenu *fourccMenu;
@property (nonatomic, strong) NSMenuItem *selectedFourccItem;
@property (nonatomic, strong) NSMutableArray *suportCaptureFormatList;
@property (nonatomic, assign) int lineNumber;
@property (nonatomic, assign) BOOL continuousAutoSwitch;
@property (nonatomic, assign) int currentCaptrueFormatIndex;
@property (nonatomic, strong) NSTimer *timer;
@property (nonatomic, strong) NSString *inUseDevicePath;

- (void)onVideoCaptureProc;
- (void)onAudioCaptureProc;


- (void)onVideoEncodeProc;
- (void)onVTBoxEncodeFrame:(const uint8_t**)nalus nalu_lens:(uint32_t*) nalu_lens nalu_num:(uint32_t) nalu_num frame_info:(mw_venc_frame_info_t*) frame_info;
- (void)onAacEncodeFrame:(const uint8_t*)frame size:(size_t) size timestamp:(uint64_t) timestamp;


- (id)initWithFrame:(NSRect)frameRect lineNumber:(int)lineNumber;
- (void)destory;
- (void)startRecord:(NSString *)fileNam;
- (void)stopRecord;
- (BOOL)isCapturing;
- (BOOL)isRecording;
- (BOOL)isDoingContinuousAutoSwitch;
@end

NS_ASSUME_NONNULL_END
