////////////////////////////////////////////////////////////////////////////////
// CONFIDENTIAL and PROPRIETARY software of Magewell Electronics Co., Ltd.
// Copyright (c) 2011-2019 Magewell Electronics Co., Ltd. (Nanjing)
// All rights reserved.
// This copyright notice MUST be reproduced on all authorized copies.
////////////////////////////////////////////////////////////////////////////////

#pragma once

#include <stdlib.h>
#include <stdint.h>
#include "faac/include/faac.h"

typedef void(*AUDIO_ENCODE_CALLBACK)(uint8_t *frame, size_t frame_size, uint64_t timestamp, uint32_t seq, void *param);

class FAACEncoder {
public:
    FAACEncoder();
    virtual ~FAACEncoder();
    
    int setCallback(AUDIO_ENCODE_CALLBACK cb, void *param);

    int open(uint32_t sampleRate, uint16_t channels, uint32_t bitrate = 0);
    int close();
    
    void encode(uint8_t *data, uint32_t length, uint64_t timestamp);

private:
	faacEncHandle _faac;
	faacEncConfigurationPtr _faacCfg;
	uint16_t _channels;
	unsigned long _inputSamples;
	unsigned long _maxOutputBytes;
    uint32_t _frameCount;

    uint8_t *_encIn;
    uint32_t _encInOffset, _encInSize;
    uint8_t *_encOut;
    
    AUDIO_ENCODE_CALLBACK _callback;
    void *_param;
};
